// Copyright 2014 Google Inc. All Rights Reserved.

#ifndef ANDROID_AUTO_PROJECTION_PROTOCOL_CORE_UTIL_SEM_H
#define ANDROID_AUTO_PROJECTION_PROTOCOL_CORE_UTIL_SEM_H

#include <semaphore.h>

/**
 * Wrap a semaphore. Customize this to suit the target platform & OS.
 * The android implementation uses a standard linux semaphore.
 */
class Semaphore {
public:
    Semaphore();
    Semaphore(int value);
    ~Semaphore();
    bool down();
    bool up();
private:
    sem_t mSem;
};

#endif // ANDROID_AUTO_PROJECTION_PROTOCOL_CORE_UTIL_SEM_H
